// ConfigurePanelHG.cpp : implementation file
//

#include "stdafx.h"
#include "db_apivcclient.h"
#include "ConfigurePanelHG.h"
#include <afxtempl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigurePanelHG dialog


CConfigurePanelHG::CConfigurePanelHG(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigurePanelHG::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigurePanelHG)
	m_AccountName = _T("");
	m_sPanelName = _T("");
	//}}AFX_DATA_INIT
}


CConfigurePanelHG::CConfigurePanelHG(IApplication* pApp)
	: CDialog(CConfigurePanelHG::IDD, NULL)
{
	pApplication = pApp;
}


void CConfigurePanelHG::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigurePanelHG)
	DDX_Control(pDX, IDC_LIST_INPANELHG, m_InPanelHGlist);
	DDX_Control(pDX, IDC_LIST_AVAILHGS, m_AvailHGList);
	DDX_Control(pDX, IDC_CMB_PANEL, m_PanelList);
	DDX_Control(pDX, IDC_CMB_ACCT, m_AccountList);
	DDX_Text(pDX, IDC_EDIT_ACCTNAME, m_AccountName);
	DDX_Text(pDX, IDC_EDIT_PANELNAME, m_sPanelName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigurePanelHG, CDialog)
	//{{AFX_MSG_MAP(CConfigurePanelHG)
	ON_CBN_SELCHANGE(IDC_CMB_ACCT, OnSelchangeCmbAcct)
	ON_CBN_SELCHANGE(IDC_CMB_PANEL, OnSelchangeCmbPanel)
	ON_BN_CLICKED(IDC_BTN_CONFHG, OnBtnConfigurePanelHG)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigurePanelHG message handlers

void CConfigurePanelHG::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			CString sAcctid;
			sAcctid.Format(L"%ld",pAccount->AccountID);
			m_AccountList.AddString(sAcctid);
			pAccount->Release();
		}
		pDisp->Release();
	}
}

void CConfigurePanelHG::LoadPanels()
{
	int index = m_AccountList.GetCurSel();
	CString sAcctName;
	m_AccountList.GetLBText(index,sAcctName);
	_variant_t vPanels;
	vPanels.Clear();
	long lAccountID = _wtoi(sAcctName);
	pApplication->GetPanelsByAcctID(lAccountID,&vPanels);
	if(vPanels.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No Panels");
			return;
	}
		
	long uBound =0 ;
	IHWDevice *pPanels =NULL;
	COleSafeArray sa(vPanels);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	//BSTR bstrPanel;
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pPanels);
		if (pPanels != NULL)
		{	
			CString sPanelid;
			sPanelid.Format(L"%ld",pPanels->HWDeviceID);
			m_PanelList.AddString(sPanelid);	
			pPanels->Release();
		}
		pDisp->Release();
	}
}

void CConfigurePanelHG::LoadAvailableHGs()
{
	int index = m_AccountList.GetCurSel();
	if(index<0)
		return;
	CString sAcctID;
	m_AccountList.GetLBText(index,sAcctID);
	long lAcctID = _wtoi(sAcctID);

	_variant_t vHolidayGrps;
	vHolidayGrps.Clear();
	pApplication->GetHolidayGroupsByAcctID(lAcctID, &vHolidayGrps);
	
	if(vHolidayGrps.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IHolidayGroup *pHG = NULL;
	
	COleSafeArray sa(vHolidayGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	m_AvailHGList.AddString(_T("0"));
	for(long i =0 ;i <= uBound ; i++)	
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHolidayGroup,(void**)&pHG);
		if (pHG != NULL)
		{
			CString sHGID;
			sHGID.Format(L"%ld",pHG->HolGrpID);
			m_AvailHGList.AddString(sHGID);
			pHG->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);		
}

void CConfigurePanelHG::LoadConfiguredHGs()
{
	int index = m_PanelList.GetCurSel();
	if(index<0)
		return;
	CString sPanelID;
	m_PanelList.GetLBText(index,sPanelID);
	long lPanelID = _wtoi(sPanelID);

	_variant_t vHolidayGrps;
	vHolidayGrps.Clear();
	pApplication->GetConfiguredHolidayGroupsByPanel(lPanelID, &vHolidayGrps);
	
	if(vHolidayGrps.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0, lBound =0  ;
	IHolidayGroup *pHG = NULL;
	
	COleSafeArray sa;
	sa = vHolidayGrps;
	sa.GetLBound(1,&lBound);
	sa.GetUBound(1,&uBound);

	for(long i =lBound ;i <= uBound ; i++)	
	{
		long lHGID;
		sa.GetElement(&i, &lHGID);
		CString sHGName;
		sHGName.Format(_T("%ld"), lHGID);
		m_InPanelHGlist.AddString(sHGName);
	}
	UpdateData(FALSE);	
}

void CConfigurePanelHG::OnSelchangeCmbAcct() 
{
	m_PanelList.ResetContent();
	LoadPanels();
	m_AvailHGList.ResetContent();
	LoadAvailableHGs();
}

void CConfigurePanelHG::OnSelchangeCmbPanel() 
{
	m_InPanelHGlist.ResetContent();
	LoadConfiguredHGs();
}

void CConfigurePanelHG::OnBtnConfigurePanelHG() 
{
	int index_acct = m_AccountList.GetCurSel();
	if(index_acct<0)
		return;
	CString sAcctID;
	m_AccountList.GetLBText(index_acct,sAcctID);
	long lAccountID = _wtoi(sAcctID);

	int index_panel = m_PanelList.GetCurSel();
	if(index_panel<0)
		return;
	CString sPanelID;
	m_PanelList.GetLBText(index_panel,sPanelID);
	long lPanelID = _wtoi(sPanelID);

	// Filling the HG Array -- Guru
	CArray<int,int> sels;
	VARIANT vHGs;
	int n = m_AvailHGList.GetSelCount();
	COleSafeArray saHGs;
	saHGs.CreateOneDim(VT_I4,n);
	sels.SetSize(n);
	m_AvailHGList.GetSelItems(n, sels.GetData());
	for(long i = 0; i < n; i++)                                                  
	{                                                      
		CString sHGID;       
		long lHGID = 0;
		m_AvailHGList.GetText(sels[i], sHGID);
		lHGID = _wtoi(sHGID);
		saHGs.PutElement(&i,&lHGID);
	}
	vHGs = saHGs.Detach();
	long lStatus = 0;

	pApplication->ConfigurePanelHolidayGroup(lAccountID, lPanelID, &vHGs, &lStatus);

	if (lStatus == 105)
	{
		AfxMessageBox(L"Invalid account");
		return;
	}
	if (lStatus == 501)
	{
		AfxMessageBox(L"Invalid panel");
		return;
	}
	if (lStatus == 802)
	{
		AfxMessageBox(L"Invalid Holiday Group ID");
		return;
	}
	if(lStatus ==0)
	{
		AfxMessageBox(L"Holiday Group Configuration to panel succeeded");
		CDialog::OnOK();
	}
	if(lStatus ==1)
	{
		AfxMessageBox(L"Holiday Group Configuration to panel Failed");
	}
	
}

BOOL CConfigurePanelHG::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadAccounts();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
